-- -114
return Def.ActorFrame{
	LoadActor("songinfopane"),
	-- LoadActor("songinfopain") .. {
		-- OnCommand=function(self)
			-- self:diffuseramp():effectcolor1(Color.Invisible):effectcolor2(color("#FFFFFF22")):blend(Blend.Add):effectclock("bgm")
		-- end,
	-- },
	
	-- Genre display.
	Def.ActorFrame {
		Name="GenreContainer",
		InitCommand=function(self)
				self:y(-23):zoom(0.9)
		end,
		
		Def.BitmapText {
			Name = "Header",
			Font = "Common Small",
			InitCommand=function(self)
				self:xy(-114,-5):zoom(0.5):horizalign(left):vertalign(bottom):strokecolor(Color.Outline)
			end
		},
		
		Def.BitmapText {
			Name = "Genre",
			Font = "Common Normal",
			InitCommand=function(self)
				self:zoom(0.5):y(1):vertalign(top):strokecolor(Color.Outline):maxwidth((854/3)/0.5)
			end
		},
		
		SetCommand=function(self)
			local song = GAMESTATE:GetCurrentSong()
			local Header = self:GetChild("Header")
			local Genre = self:GetChild("Genre")
			
			if not GAMESTATE:IsCourseMode() and song then
				Header:settext(song:GenreIsParaStyle() and THEME:GetString("ScreenSelectMusic", "GenrePara"):upper() or THEME:GetString("ScreenSelectMusic", "GenreGenre"):upper())
				Genre:settext(song:GetGenre() ~= "" and song:GetGenre() or THEME:GetString("Misc", "Unknown"))
			else
				Header:settext("")
				if GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() then
					Genre:settext("NONSTOP")
				else
					local wheelType = ToEnumShortString(SCREENMAN:GetTopScreen():GetChild("MusicWheel"):GetSelectedType())
					Genre:settext(wheelType == "Section" and "GROUP" or "")
				end
			end
				
		end,
		
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set")
	},
	
	-- Song length.
	Def.ActorFrame {
		Name="SongTimeContainer",
		
		InitCommand=function(self)
			self:x(132/2):y(20)
		end,
		
		Def.BitmapText {
			Font = "Common Small",
			Text="LENGTH",
			InitCommand=function(self)
				self:xy(-50,-16):zoom(0.5):strokecolor(Color.Outline):horizalign(left)
			end,
		},
		
		Def.BitmapText {
			Font = "Common Normal",
			Name="SongTime",
			InitCommand=function(self)
				self:zoom(0.5):strokecolor(Color.Outline)
			end,
			SetCommand=function(self)
				local curSelection = nil
				local length = 0.0
				local trailSongs = 0
				-- Just in case!
				local musicRate = GAMESTATE:GetSongOptionsObject("ModsLevel_Preferred"):MusicRate()
				
				if GAMESTATE:IsCourseMode() then
					curSelection = GAMESTATE:GetCurrentCourse()
					self:diffuse(Color.White)
					if curSelection then
						local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber())
						if trail then
							length = TrailUtil.GetTotalSeconds(trail)
							trailSongs = #trail:GetTrailEntries()
						else
							length = 0.0
						end
					else
						length = 0.0
					end
				else
					curSelection = GAMESTATE:GetCurrentSong()
					if curSelection then
						length = curSelection:MusicLengthSeconds()
						if curSelection:IsLong() then
							self:diffuse(Color.Yellow)
						elseif curSelection:IsMarathon() then
							self:diffuse(Color.Orange)
						else
							self:diffuse(Color.White)
						end
					else
						length = 0.0
						self:diffuse(Color.Outline)
					end
				end
				
				-- Deal with the rate mod.
				length = length / musicRate
				
				-- Horrible things exist out there... Let's take them into consideration
				local formattedLength = length >= 3600 and SecondsToHHMMSS(length) or (length < 60 and length > 0) and SecondsToMSSMsMs(length) or SecondsToMSS(length)
				self:settext(GAMESTATE:IsCourseMode() and formattedLength .. " - " .. trailSongs .. " SONGS" or formattedLength)
			end,
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set"),
			-- help it notice if the rate mod might have been changed through OptionsList
			OptionsListStartMessageCommand=cmd(playcommand,"Set"),
			OptionsListResetMessageCommand=cmd(playcommand,"Set"),
		}
	},
	
	-- BPM display.
	Def.ActorFrame {
		InitCommand=function(self)
			self:x(-132/2):y(20)
		end,
		
		-- Header.
		Def.BitmapText {
			Font = "Common Small",
			Text = "BPM",
			InitCommand=function(self)
				self:xy(-70,-16):zoom(0.5):strokecolor(Color.Outline):horizalign(left)
			end
		},
		
		-- Rate mod multiplier display.
		Def.BitmapText {
			Font = "Common Small",
			InitCommand=function(self)
				self:horizalign(right):xy(56,-16):zoom(0.4):strokecolor(Color.Black):diffuseblink():
					effectcolor1(LocalGoldColor(1)):effectcolor2(Color.White):effecttiming(0.1,0.1,0.1,0.1,0.6):effectclock("bgm")
			end,
			OnCommand=cmd(playcommand,"Set"),
			-- help it notice if the rate mod might have been changed through OptionsList
			OptionsListStartMessageCommand=cmd(playcommand,"Set"),
			OptionsListResetMessageCommand=cmd(playcommand,"Set"),
			SetCommand=function(self)
				local musicRate = GAMESTATE:GetSongOptionsObject("ModsLevel_Preferred"):MusicRate()
				if musicRate ~= 1 then
					self:visible(true):settext("x " .. tostring(math.round(musicRate*100) / 100)) --round doesn't bloody work with math.modf apparently
				else
					self:visible(false)
				end
			end
		},
		
		-- The BPM.
		LoadFont("Common", "Normal") .. {
			Name="BPM",
			InitCommand=function(self)
				self:strokecolor(Color.Outline):zoom(0.5):maxwidth(140)
			end,
			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentSong();
				if not song then
					self:settext("");
					return;
				end

				local Min = 999999
				local Max = 0
				local musicRate = GAMESTATE:GetSongOptionsObject("ModsLevel_Preferred"):MusicRate()
				local SongBPMs = song:GetDisplayBpms()
				local s
				
				-- Floor it because this started acting up in SM5.3 without the flooring
				Min = math.floor(math.min(Min, SongBPMs[1]) * musicRate)
				Max = math.floor(math.max(Max, SongBPMs[2]) * musicRate)
				if Min == Max then
					s = string.format("%i", Min)
				else
					s = string.format("%i - %i", Min, Max)
				end
				
				if AnyPlayerHasSplitTiming() then
					s = s .. "?"
				end
				
				self:settext(s)
			end,
			OnCommand=cmd(playcommand,"Set"),
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
			OptionsListStartMessageCommand=cmd(playcommand,"Set"),
			-- help notice potential split timing shenanigans
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set"),
			CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set")
		}
	},
	
	-- CDTitle.
	Def.Sprite {
		Name = "CDTitle",
		SetCommand=function(self)
			local song = GAMESTATE:GetCurrentSong()
			if song and song:HasCDTitle() then
				self:LoadBanner(song:GetCDTitlePath())
			elseif song then
				self:LoadBanner(THEME:GetPathG("Common", "window icon"))
			else
				-- Fun fact:
				-- In Lua, "false" = "nil"... except for this ONE specific function
				self:Load(nil)
			end
			self:scaletofit(-20,-16,20,16):xy(154,34):bob():effectmagnitude(0,1,0)
		end,
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set")
	},
}
